/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1;

import com.roguewave.chart.core.v2_1.CellProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.PropertyBlock;
import com.roguewave.chart.core.v2_1.PropertySet;
import com.roguewave.chart.core.v2_1.events.DataUpdateEvent;
import com.roguewave.chart.core.v2_1.events.DataUpdateListener;
import com.roguewave.chart.core.v2_1.events.PropertyUpdateEvent;
import com.roguewave.chart.core.v2_1.events.PropertyUpdateListener;
import com.roguewave.chart.overlay.core.v2_1.NumericFormatter;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;

public class ChartProperties
implements DataUpdateListener,
Serializable {
    double chartHeight_ = 4.0;
    double dataRangeLow_ = 0.0;
    double dataRangeHigh_ = 1.0;
    double valueScale_ = 1.0;
    Vector propertySets_ = null;
    Customizer styleCustomizer2D_ = null;
    Customizer styleCustomizer3D_ = null;
    Vector listeners_ = new Vector();
    NumericFormatter formatter_ = null;
    ClickCallbackGenerator callbackGenerator_ = null;

    public NumericFormatter getScale() {
        return this.formatter_;
    }

    public void setScale(NumericFormatter formatter) {
        this.formatter_ = formatter;
    }

    public Customizer get2DStyleCustomizer() {
        return this.styleCustomizer2D_;
    }

    public void set2DStyleCustomizer(Customizer styleCustomizer) {
        this.styleCustomizer2D_ = styleCustomizer;
    }

    public Customizer get3DStyleCustomizer() {
        return this.styleCustomizer3D_;
    }

    public void set3DStyleCustomizer(Customizer styleCustomizer) {
        this.styleCustomizer3D_ = styleCustomizer;
    }

    public double getScaledValue(DataModel data, int row, int column) {
        return (data.getValue(row, column) - this.dataRangeLow_) * this.valueScale_;
    }

    public double getChartHeight() {
        return this.chartHeight_;
    }

    public void setChartHeight(double height) {
        this.chartHeight_ = height;
        this.valueScale_ = this.chartHeight_ / (this.dataRangeHigh_ - this.dataRangeLow_);
    }

    public void setDataRange(DataModel data) {
        this.dataRangeLow_ = data.getRangeLow();
        if (this.dataRangeLow_ > 0.0) {
            this.dataRangeLow_ = 0.0;
        }
        this.dataRangeHigh_ = data.getRangeHigh();
        this.valueScale_ = this.chartHeight_ / (this.dataRangeHigh_ - this.dataRangeLow_);
    }

    public double getDataRangeHigh() {
        return this.dataRangeHigh_;
    }

    public void setDataRangeHigh(double high) {
        this.dataRangeHigh_ = high;
        this.valueScale_ = this.chartHeight_ / (this.dataRangeHigh_ - this.dataRangeLow_);
    }

    public double getDataRangeLow() {
        return this.dataRangeLow_;
    }

    public void setDataRangeLow(double low) {
        this.dataRangeLow_ = low;
        this.valueScale_ = this.chartHeight_ / (this.dataRangeHigh_ - this.dataRangeLow_);
    }

    public double scaleY(double value) {
        return (value - this.dataRangeLow_) * this.valueScale_;
    }

    public void addPropertySet(PropertySet propertySet) {
        if (this.propertySets_ == null) {
            this.propertySets_ = new Vector();
        }
        this.propertySets_.addElement(propertySet);
    }

    public void addProperty(String name, Object property, int row, int column, int width, int height) {
        CellProperties props = new CellProperties();
        props.addProperty(name, property);
        PropertyBlock block = new PropertyBlock(row, column, width, height, props);
        this.addPropertySet(block);
    }

    public void addProperty(String name, Object value) {
        CellProperties props = new CellProperties();
        props.addProperty(name, value);
        PropertyBlock block = new PropertyBlock(-1, -1, 1, 1, props);
        this.addPropertySet(block);
    }

    public Object getProperty(String name, int row, int column, Object defaultValue, double dataValue) {
        if (this.propertySets_ == null) {
            return defaultValue;
        }
        Object value = defaultValue;
        for (int i = 0; i < this.propertySets_.size(); ++i) {
            PropertySet ps = (PropertySet)this.propertySets_.elementAt(i);
            value = ps.getProperty(name, row, column, value, dataValue);
        }
        return value;
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.getProperty(name, -1, -1, defaultValue, 0.0);
    }

    public double getProperty(String name, double defaultValue) {
        Double value = (Double)this.getProperty(name, new Double(defaultValue));
        return value;
    }

    public boolean getProperty(String name, boolean defaultValue) {
        Boolean value = (Boolean)this.getProperty(name, new Boolean(defaultValue));
        return value;
    }

    public Color getColor(int row, int column, Color defaultColor, double dataValue) {
        return (Color)this.getProperty("ForegroundColor", row, column, defaultColor, dataValue);
    }

    public ClickCallbackGenerator getClickCallbackGenerator() {
        return this.callbackGenerator_;
    }

    public void setClickCallbackGenerator(ClickCallbackGenerator ccg) {
        this.callbackGenerator_ = ccg;
    }

    public void dataUpdate(DataUpdateEvent updateEvent) {
        DataModel data = updateEvent.getData();
        if (data.getRangeLow() < this.dataRangeLow_) {
            this.dataRangeLow_ = data.getRangeLow();
        }
        if (data.getRangeHigh() > this.dataRangeHigh_) {
            this.dataRangeHigh_ = data.getRangeHigh();
        }
        this.valueScale_ = this.chartHeight_ / (this.dataRangeHigh_ - this.dataRangeLow_);
        this.propertyUpdate();
    }

    public void propertyUpdate() {
        Vector snapshot;
        ChartProperties chartProperties = this;
        synchronized (chartProperties) {
            try {
                snapshot = (Vector)this.listeners_.clone();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        PropertyUpdateEvent pue = new PropertyUpdateEvent(this);
        for (int i = 0; i < snapshot.size(); ++i) {
            ((PropertyUpdateListener)snapshot.elementAt(i)).propertyUpdate(pue);
        }
    }

    public synchronized void addPropertyUpdateListener(PropertyUpdateListener listener) {
        this.listeners_.addElement(listener);
    }

    public synchronized void removePropertyUpdateListener(PropertyUpdateListener listener) {
        this.listeners_.removeElement(listener);
    }
}

